/*
 * Decompiled with CFR 0.152.
 */
package androidx.renderscript;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import androidx.renderscript.BaseObj;
import androidx.renderscript.Element;
import androidx.renderscript.RSDriverException;
import androidx.renderscript.RSIllegalArgumentException;
import androidx.renderscript.RSInvalidStateException;
import androidx.renderscript.RSRuntimeException;
import androidx.renderscript.Sampler;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RenderScript {
    static final String LOG_TAG = "RenderScript_jni";
    static final boolean DEBUG = false;
    static final boolean LOG_ENABLED = false;
    static final int SUPPORT_LIB_API = 23;
    static final int SUPPORT_LIB_VERSION = 2301;
    private static ArrayList<RenderScript> mProcessContextList = new ArrayList();
    private boolean mIsProcessContext = false;
    private boolean mEnableMultiInput = false;
    private int mDispatchAPILevel = 0;
    private int mContextFlags = 0;
    private int mContextSdkVersion = 0;
    private Context mApplicationContext;
    private String mNativeLibDir;
    private static String mBlackList = "";
    static boolean sInitialized;
    static boolean sUseGCHooks;
    static Object sRuntime;
    static Method registerNativeAllocation;
    static Method registerNativeFree;
    static Object lock;
    private static int sNative;
    private static int sSdkVersion;
    private static boolean useIOlib;
    private static boolean useNative;
    public static final int CREATE_FLAG_NONE = 0;
    static int sPointerSize;
    private static final String CACHE_PATH = "com.android.renderscript.cache";
    static String mCachePath;
    ContextType mContextType = ContextType.NORMAL;
    long mContext;
    private boolean mDestroyed = false;
    long mIncCon;
    boolean mIncLoaded;
    ReentrantReadWriteLock mRWLock;
    MessageThread mMessageThread;
    Element mElement_U8;
    Element mElement_I8;
    Element mElement_U16;
    Element mElement_I16;
    Element mElement_U32;
    Element mElement_I32;
    Element mElement_U64;
    Element mElement_I64;
    Element mElement_F32;
    Element mElement_F64;
    Element mElement_BOOLEAN;
    Element mElement_ELEMENT;
    Element mElement_TYPE;
    Element mElement_ALLOCATION;
    Element mElement_SAMPLER;
    Element mElement_SCRIPT;
    Element mElement_A_8;
    Element mElement_RGB_565;
    Element mElement_RGB_888;
    Element mElement_RGBA_5551;
    Element mElement_RGBA_4444;
    Element mElement_RGBA_8888;
    Element mElement_FLOAT_2;
    Element mElement_FLOAT_3;
    Element mElement_FLOAT_4;
    Element mElement_DOUBLE_2;
    Element mElement_DOUBLE_3;
    Element mElement_DOUBLE_4;
    Element mElement_UCHAR_2;
    Element mElement_UCHAR_3;
    Element mElement_UCHAR_4;
    Element mElement_CHAR_2;
    Element mElement_CHAR_3;
    Element mElement_CHAR_4;
    Element mElement_USHORT_2;
    Element mElement_USHORT_3;
    Element mElement_USHORT_4;
    Element mElement_SHORT_2;
    Element mElement_SHORT_3;
    Element mElement_SHORT_4;
    Element mElement_UINT_2;
    Element mElement_UINT_3;
    Element mElement_UINT_4;
    Element mElement_INT_2;
    Element mElement_INT_3;
    Element mElement_INT_4;
    Element mElement_ULONG_2;
    Element mElement_ULONG_3;
    Element mElement_ULONG_4;
    Element mElement_LONG_2;
    Element mElement_LONG_3;
    Element mElement_LONG_4;
    Element mElement_MATRIX_4X4;
    Element mElement_MATRIX_3X3;
    Element mElement_MATRIX_2X2;
    Sampler mSampler_CLAMP_NEAREST;
    Sampler mSampler_CLAMP_LINEAR;
    Sampler mSampler_CLAMP_LINEAR_MIP_LINEAR;
    Sampler mSampler_WRAP_NEAREST;
    Sampler mSampler_WRAP_LINEAR;
    Sampler mSampler_WRAP_LINEAR_MIP_LINEAR;
    Sampler mSampler_MIRRORED_REPEAT_NEAREST;
    Sampler mSampler_MIRRORED_REPEAT_LINEAR;
    Sampler mSampler_MIRRORED_REPEAT_LINEAR_MIP_LINEAR;
    RSMessageHandler mMessageCallback = null;
    RSErrorHandler mErrorCallback = null;

    public static void setBlackList(String blackList) {
        if (blackList != null) {
            mBlackList = blackList;
        }
    }

    public static void forceCompat() {
        sNative = 0;
    }

    native boolean nLoadSO(boolean var1, int var2, String var3);

    native boolean nLoadIOSO();

    native long nDeviceCreate();

    native void nDeviceDestroy(long var1);

    native void nDeviceSetConfig(long var1, int var3, int var4);

    native int nContextGetUserMessage(long var1, int[] var3);

    native String nContextGetErrorMessage(long var1);

    native int nContextPeekMessage(long var1, int[] var3);

    native void nContextInitToClient(long var1);

    native void nContextDeinitToClient(long var1);

    int getDispatchAPILevel() {
        return this.mDispatchAPILevel;
    }

    boolean isUseNative() {
        return useNative;
    }

    static native int rsnSystemGetPointerSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPointerSize() {
        Object object = lock;
        synchronized (object) {
            if (!sInitialized) {
                throw new RSInvalidStateException("Calling getPointerSize() before any RenderScript instantiated");
            }
        }
        return sPointerSize;
    }

    private static boolean setupNative(int sdkVersion, Context ctx) {
        if (Build.VERSION.SDK_INT < sdkVersion && Build.VERSION.SDK_INT < 21) {
            sNative = 0;
        }
        if (sNative == -1) {
            int forcecompat = 0;
            try {
                Class<?> sysprop = Class.forName("android.os.SystemProperties");
                Class[] signature = new Class[]{String.class, Integer.TYPE};
                Method getint = sysprop.getDeclaredMethod("getInt", signature);
                Object[] args = new Object[]{"debug.rs.forcecompat", new Integer(0)};
                forcecompat = (Integer)getint.invoke(null, args);
            }
            catch (Exception sysprop) {
                // empty catch block
            }
            sNative = Build.VERSION.SDK_INT >= 19 && forcecompat == 0 ? 1 : 0;
            if (sNative == 1) {
                ApplicationInfo info;
                try {
                    info = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), 128);
                }
                catch (PackageManager.NameNotFoundException e) {
                    return true;
                }
                long minorVersion = 0L;
                try {
                    Class<?> javaRS = Class.forName("android.renderscript.RenderScript");
                    Method getMinorID = javaRS.getDeclaredMethod("getMinorID", new Class[0]);
                    minorVersion = (Long)getMinorID.invoke(null, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (info.metaData != null) {
                    if (info.metaData.getBoolean("androidx.renderscript.EnableAsyncTeardown") && minorVersion == 0L) {
                        sNative = 0;
                    }
                    if (info.metaData.getBoolean("androidx.renderscript.EnableBlurWorkaround") && Build.VERSION.SDK_INT <= 19) {
                        sNative = 0;
                    }
                }
            }
        }
        if (sNative == 1) {
            String deviceInfo;
            if (mBlackList.length() > 0 && mBlackList.contains(deviceInfo = '(' + Build.MANUFACTURER + ':' + Build.PRODUCT + ':' + Build.MODEL + ')')) {
                sNative = 0;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void setupDiskCache(File cacheDir) {
        File f = new File(cacheDir, CACHE_PATH);
        mCachePath = f.getAbsolutePath();
        f.mkdirs();
    }

    native long rsnContextCreate(long var1, int var3, int var4, int var5, String var6);

    synchronized long nContextCreate(long dev, int ver, int sdkVer, int contextType, String nativeLibDir) {
        return this.rsnContextCreate(dev, ver, sdkVer, contextType, nativeLibDir);
    }

    native void rsnContextDestroy(long var1);

    synchronized void nContextDestroy() {
        this.validate();
        ReentrantReadWriteLock.WriteLock wlock = this.mRWLock.writeLock();
        wlock.lock();
        long curCon = this.mContext;
        this.mContext = 0L;
        wlock.unlock();
        this.rsnContextDestroy(curCon);
    }

    native void rsnContextSetPriority(long var1, int var3);

    synchronized void nContextSetPriority(int p) {
        this.validate();
        this.rsnContextSetPriority(this.mContext, p);
    }

    native void rsnContextDump(long var1, int var3);

    synchronized void nContextDump(int bits) {
        this.validate();
        this.rsnContextDump(this.mContext, bits);
    }

    native void rsnContextFinish(long var1);

    synchronized void nContextFinish() {
        this.validate();
        this.rsnContextFinish(this.mContext);
    }

    native void rsnContextSendMessage(long var1, int var3, int[] var4);

    synchronized void nContextSendMessage(int id, int[] data) {
        this.validate();
        this.rsnContextSendMessage(this.mContext, id, data);
    }

    native void rsnObjDestroy(long var1, long var3);

    void nObjDestroy(long id) {
        if (this.mContext != 0L) {
            this.rsnObjDestroy(this.mContext, id);
        }
    }

    native long rsnElementCreate(long var1, long var3, int var5, boolean var6, int var7);

    synchronized long nElementCreate(long type, int kind, boolean norm, int vecSize) {
        this.validate();
        return this.rsnElementCreate(this.mContext, type, kind, norm, vecSize);
    }

    native long rsnElementCreate2(long var1, long[] var3, String[] var4, int[] var5);

    synchronized long nElementCreate2(long[] elements, String[] names, int[] arraySizes) {
        this.validate();
        return this.rsnElementCreate2(this.mContext, elements, names, arraySizes);
    }

    native void rsnElementGetNativeData(long var1, long var3, int[] var5);

    synchronized void nElementGetNativeData(long id, int[] elementData) {
        this.validate();
        this.rsnElementGetNativeData(this.mContext, id, elementData);
    }

    native void rsnElementGetSubElements(long var1, long var3, long[] var5, String[] var6, int[] var7);

    synchronized void nElementGetSubElements(long id, long[] IDs, String[] names, int[] arraySizes) {
        this.validate();
        this.rsnElementGetSubElements(this.mContext, id, IDs, names, arraySizes);
    }

    native long rsnTypeCreate(long var1, long var3, int var5, int var6, int var7, boolean var8, boolean var9, int var10);

    synchronized long nTypeCreate(long eid, int x, int y, int z, boolean mips, boolean faces, int yuv) {
        this.validate();
        return this.rsnTypeCreate(this.mContext, eid, x, y, z, mips, faces, yuv);
    }

    native void rsnTypeGetNativeData(long var1, long var3, long[] var5);

    synchronized void nTypeGetNativeData(long id, long[] typeData) {
        this.validate();
        this.rsnTypeGetNativeData(this.mContext, id, typeData);
    }

    native long rsnAllocationCreateTyped(long var1, long var3, int var5, int var6, long var7);

    synchronized long nAllocationCreateTyped(long type, int mip, int usage, long pointer) {
        this.validate();
        return this.rsnAllocationCreateTyped(this.mContext, type, mip, usage, pointer);
    }

    native long rsnAllocationCreateFromBitmap(long var1, long var3, int var5, Bitmap var6, int var7);

    synchronized long nAllocationCreateFromBitmap(long type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCreateFromBitmap(this.mContext, type, mip, bmp, usage);
    }

    native long rsnAllocationCreateBitmapBackedAllocation(long var1, long var3, int var5, Bitmap var6, int var7);

    synchronized long nAllocationCreateBitmapBackedAllocation(long type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCreateBitmapBackedAllocation(this.mContext, type, mip, bmp, usage);
    }

    native long rsnAllocationCubeCreateFromBitmap(long var1, long var3, int var5, Bitmap var6, int var7);

    synchronized long nAllocationCubeCreateFromBitmap(long type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCubeCreateFromBitmap(this.mContext, type, mip, bmp, usage);
    }

    native long rsnAllocationCreateBitmapRef(long var1, long var3, Bitmap var5);

    synchronized long nAllocationCreateBitmapRef(long type, Bitmap bmp) {
        this.validate();
        return this.rsnAllocationCreateBitmapRef(this.mContext, type, bmp);
    }

    native long rsnAllocationCreateFromAssetStream(long var1, int var3, int var4, int var5);

    synchronized long nAllocationCreateFromAssetStream(int mips, int assetStream, int usage) {
        this.validate();
        return this.rsnAllocationCreateFromAssetStream(this.mContext, mips, assetStream, usage);
    }

    native void rsnAllocationCopyToBitmap(long var1, long var3, Bitmap var5);

    synchronized void nAllocationCopyToBitmap(long alloc, Bitmap bmp) {
        this.validate();
        this.rsnAllocationCopyToBitmap(this.mContext, alloc, bmp);
    }

    native void rsnAllocationSyncAll(long var1, long var3, int var5);

    synchronized void nAllocationSyncAll(long alloc, int src) {
        this.validate();
        this.rsnAllocationSyncAll(this.mContext, alloc, src);
    }

    native void rsnAllocationSetSurface(long var1, long var3, Surface var5);

    synchronized void nAllocationSetSurface(long alloc, Surface sur) {
        this.validate();
        this.rsnAllocationSetSurface(this.mContext, alloc, sur);
    }

    native void rsnAllocationIoSend(long var1, long var3);

    synchronized void nAllocationIoSend(long alloc) {
        this.validate();
        this.rsnAllocationIoSend(this.mContext, alloc);
    }

    native void rsnAllocationIoReceive(long var1, long var3);

    synchronized void nAllocationIoReceive(long alloc) {
        this.validate();
        this.rsnAllocationIoReceive(this.mContext, alloc);
    }

    native ByteBuffer rsnAllocationGetByteBuffer(long var1, long var3, int var5, int var6, int var7);

    synchronized ByteBuffer nAllocationGetByteBuffer(long alloc, int xBytesSize, int dimY, int dimZ) {
        this.validate();
        return this.rsnAllocationGetByteBuffer(this.mContext, alloc, xBytesSize, dimY, dimZ);
    }

    native long rsnAllocationGetStride(long var1, long var3);

    synchronized long nAllocationGetStride(long alloc) {
        this.validate();
        return this.rsnAllocationGetStride(this.mContext, alloc);
    }

    native void rsnAllocationGenerateMipmaps(long var1, long var3);

    synchronized void nAllocationGenerateMipmaps(long alloc) {
        this.validate();
        this.rsnAllocationGenerateMipmaps(this.mContext, alloc);
    }

    native void rsnAllocationCopyFromBitmap(long var1, long var3, Bitmap var5);

    synchronized void nAllocationCopyFromBitmap(long alloc, Bitmap bmp) {
        this.validate();
        this.rsnAllocationCopyFromBitmap(this.mContext, alloc, bmp);
    }

    native void rsnAllocationData1D(long var1, long var3, int var5, int var6, int var7, Object var8, int var9, int var10, int var11, boolean var12);

    synchronized void nAllocationData1D(long id, int off, int mip, int count, Object d, int sizeBytes, Element.DataType dt, int mSize, boolean usePadding) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id, off, mip, count, d, sizeBytes, dt.mID, mSize, usePadding);
    }

    native void rsnAllocationElementData1D(long var1, long var3, int var5, int var6, int var7, byte[] var8, int var9);

    synchronized void nAllocationElementData1D(long id, int xoff, int mip, int compIdx, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationElementData1D(this.mContext, id, xoff, mip, compIdx, d, sizeBytes);
    }

    native void rsnAllocationData2D(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, long var11, int var13, int var14, int var15, int var16);

    synchronized void nAllocationData2D(long dstAlloc, int dstXoff, int dstYoff, int dstMip, int dstFace, int width, int height, long srcAlloc, int srcXoff, int srcYoff, int srcMip, int srcFace) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, dstAlloc, dstXoff, dstYoff, dstMip, dstFace, width, height, srcAlloc, srcXoff, srcYoff, srcMip, srcFace);
    }

    native void rsnAllocationData2D(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, Object var11, int var12, int var13, int var14, boolean var15);

    synchronized void nAllocationData2D(long id, int xoff, int yoff, int mip, int face, int w, int h, Object d, int sizeBytes, Element.DataType dt, int mSize, boolean usePadding) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id, xoff, yoff, mip, face, w, h, d, sizeBytes, dt.mID, mSize, usePadding);
    }

    native void rsnAllocationData2D(long var1, long var3, int var5, int var6, int var7, int var8, Bitmap var9);

    synchronized void nAllocationData2D(long id, int xoff, int yoff, int mip, int face, Bitmap b) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id, xoff, yoff, mip, face, b);
    }

    native void rsnAllocationData3D(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, int var11, long var12, int var14, int var15, int var16, int var17);

    synchronized void nAllocationData3D(long dstAlloc, int dstXoff, int dstYoff, int dstZoff, int dstMip, int width, int height, int depth, long srcAlloc, int srcXoff, int srcYoff, int srcZoff, int srcMip) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, dstAlloc, dstXoff, dstYoff, dstZoff, dstMip, width, height, depth, srcAlloc, srcXoff, srcYoff, srcZoff, srcMip);
    }

    native void rsnAllocationData3D(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, int var11, Object var12, int var13, int var14, int var15, boolean var16);

    synchronized void nAllocationData3D(long id, int xoff, int yoff, int zoff, int mip, int w, int h, int depth, Object d, int sizeBytes, Element.DataType dt, int mSize, boolean usePadding) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, id, xoff, yoff, zoff, mip, w, h, depth, d, sizeBytes, dt.mID, mSize, usePadding);
    }

    native void rsnAllocationRead(long var1, long var3, Object var5, int var6, int var7, boolean var8);

    synchronized void nAllocationRead(long id, Object d, Element.DataType dt, int mSize, boolean usePadding) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id, d, dt.mID, mSize, usePadding);
    }

    native void rsnAllocationRead1D(long var1, long var3, int var5, int var6, int var7, Object var8, int var9, int var10, int var11, boolean var12);

    synchronized void nAllocationRead1D(long id, int off, int mip, int count, Object d, int sizeBytes, Element.DataType dt, int mSize, boolean usePadding) {
        this.validate();
        this.rsnAllocationRead1D(this.mContext, id, off, mip, count, d, sizeBytes, dt.mID, mSize, usePadding);
    }

    native void rsnAllocationRead2D(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, Object var11, int var12, int var13, int var14, boolean var15);

    synchronized void nAllocationRead2D(long id, int xoff, int yoff, int mip, int face, int w, int h, Object d, int sizeBytes, Element.DataType dt, int mSize, boolean usePadding) {
        this.validate();
        this.rsnAllocationRead2D(this.mContext, id, xoff, yoff, mip, face, w, h, d, sizeBytes, dt.mID, mSize, usePadding);
    }

    native long rsnAllocationGetType(long var1, long var3);

    synchronized long nAllocationGetType(long id) {
        this.validate();
        return this.rsnAllocationGetType(this.mContext, id);
    }

    native void rsnAllocationResize1D(long var1, long var3, int var5);

    synchronized void nAllocationResize1D(long id, int dimX) {
        this.validate();
        this.rsnAllocationResize1D(this.mContext, id, dimX);
    }

    native void rsnAllocationResize2D(long var1, long var3, int var5, int var6);

    synchronized void nAllocationResize2D(long id, int dimX, int dimY) {
        this.validate();
        this.rsnAllocationResize2D(this.mContext, id, dimX, dimY);
    }

    native void rsnScriptBindAllocation(long var1, long var3, long var5, int var7, boolean var8);

    synchronized void nScriptBindAllocation(long script, long alloc, int slot, boolean mUseInc) {
        this.validate();
        long curCon = this.mContext;
        if (mUseInc) {
            curCon = this.mIncCon;
        }
        this.rsnScriptBindAllocation(curCon, script, alloc, slot, mUseInc);
    }

    native void rsnScriptSetTimeZone(long var1, long var3, byte[] var5, boolean var6);

    synchronized void nScriptSetTimeZone(long script, byte[] timeZone, boolean mUseInc) {
        this.validate();
        long curCon = this.mContext;
        if (mUseInc) {
            curCon = this.mIncCon;
        }
        this.rsnScriptSetTimeZone(curCon, script, timeZone, mUseInc);
    }

    native void rsnScriptInvoke(long var1, long var3, int var5, boolean var6);

    synchronized void nScriptInvoke(long id, int slot, boolean mUseInc) {
        this.validate();
        long curCon = this.mContext;
        if (mUseInc) {
            curCon = this.mIncCon;
        }
        this.rsnScriptInvoke(curCon, id, slot, mUseInc);
    }

    native void rsnScriptForEach(long var1, long var3, long var5, int var7, long var8, long var10, byte[] var12, boolean var13);

    native void rsnScriptForEach(long var1, long var3, long var5, int var7, long var8, long var10, boolean var12);

    native void rsnScriptForEachClipped(long var1, long var3, long var5, int var7, long var8, long var10, byte[] var12, int var13, int var14, int var15, int var16, int var17, int var18, boolean var19);

    native void rsnScriptForEachClipped(long var1, long var3, long var5, int var7, long var8, long var10, int var12, int var13, int var14, int var15, int var16, int var17, boolean var18);

    synchronized void nScriptForEach(long id, int slot, long ain, long aout, byte[] params, boolean mUseInc) {
        this.validate();
        if (params == null) {
            this.rsnScriptForEach(this.mContext, this.mIncCon, id, slot, ain, aout, mUseInc);
        } else {
            this.rsnScriptForEach(this.mContext, this.mIncCon, id, slot, ain, aout, params, mUseInc);
        }
    }

    synchronized void nScriptForEachClipped(long id, int slot, long ain, long aout, byte[] params, int xstart, int xend, int ystart, int yend, int zstart, int zend, boolean mUseInc) {
        this.validate();
        if (params == null) {
            this.rsnScriptForEachClipped(this.mContext, this.mIncCon, id, slot, ain, aout, xstart, xend, ystart, yend, zstart, zend, mUseInc);
        } else {
            this.rsnScriptForEachClipped(this.mContext, this.mIncCon, id, slot, ain, aout, params, xstart, xend, ystart, yend, zstart, zend, mUseInc);
        }
    }

    native void rsnScriptForEach(long var1, long var3, int var5, long[] var6, long var7, byte[] var9, int[] var10);

    synchronized void nScriptForEach(long id, int slot, long[] ains, long aout, byte[] params, int[] limits) {
        if (!this.mEnableMultiInput) {
            Log.e((String)LOG_TAG, (String)"Multi-input kernels are not supported, please change targetSdkVersion to >= 23");
            throw new RSRuntimeException("Multi-input kernels are not supported before API 23)");
        }
        this.validate();
        this.rsnScriptForEach(this.mContext, id, slot, ains, aout, params, limits);
    }

    native void rsnScriptReduce(long var1, long var3, int var5, long[] var6, long var7, int[] var9);

    synchronized void nScriptReduce(long id, int slot, long[] ains, long aout, int[] limits) {
        this.validate();
        this.rsnScriptReduce(this.mContext, id, slot, ains, aout, limits);
    }

    native void rsnScriptInvokeV(long var1, long var3, int var5, byte[] var6, boolean var7);

    synchronized void nScriptInvokeV(long id, int slot, byte[] params, boolean mUseInc) {
        this.validate();
        long curCon = this.mContext;
        if (mUseInc) {
            curCon = this.mIncCon;
        }
        this.rsnScriptInvokeV(curCon, id, slot, params, mUseInc);
    }

    native void rsnScriptSetVarI(long var1, long var3, int var5, int var6, boolean var7);

    synchronized void nScriptSetVarI(long id, int slot, int val, boolean mUseInc) {
        this.validate();
        long curCon = this.mContext;
        if (mUseInc) {
            curCon = this.mIncCon;
        }
        this.rsnScriptSetVarI(curCon, id, slot, val, mUseInc);
    }

    native void rsnScriptSetVarJ(long var1, long var3, int var5, long var6, boolean var8);

    synchronized void nScriptSetVarJ(long id, int slot, long val, boolean mUseInc) {
        this.validate();
        long curCon = this.mContext;
        if (mUseInc) {
            curCon = this.mIncCon;
        }
        this.rsnScriptSetVarJ(curCon, id, slot, val, mUseInc);
    }

    native void rsnScriptSetVarF(long var1, long var3, int var5, float var6, boolean var7);

    synchronized void nScriptSetVarF(long id, int slot, float val, boolean mUseInc) {
        this.validate();
        long curCon = this.mContext;
        if (mUseInc) {
            curCon = this.mIncCon;
        }
        this.rsnScriptSetVarF(curCon, id, slot, val, mUseInc);
    }

    native void rsnScriptSetVarD(long var1, long var3, int var5, double var6, boolean var8);

    synchronized void nScriptSetVarD(long id, int slot, double val, boolean mUseInc) {
        this.validate();
        long curCon = this.mContext;
        if (mUseInc) {
            curCon = this.mIncCon;
        }
        this.rsnScriptSetVarD(curCon, id, slot, val, mUseInc);
    }

    native void rsnScriptSetVarV(long var1, long var3, int var5, byte[] var6, boolean var7);

    synchronized void nScriptSetVarV(long id, int slot, byte[] val, boolean mUseInc) {
        this.validate();
        long curCon = this.mContext;
        if (mUseInc) {
            curCon = this.mIncCon;
        }
        this.rsnScriptSetVarV(curCon, id, slot, val, mUseInc);
    }

    native void rsnScriptSetVarVE(long var1, long var3, int var5, byte[] var6, long var7, int[] var9, boolean var10);

    synchronized void nScriptSetVarVE(long id, int slot, byte[] val, long e, int[] dims, boolean mUseInc) {
        this.validate();
        long curCon = this.mContext;
        if (mUseInc) {
            curCon = this.mIncCon;
        }
        this.rsnScriptSetVarVE(curCon, id, slot, val, e, dims, mUseInc);
    }

    native void rsnScriptSetVarObj(long var1, long var3, int var5, long var6, boolean var8);

    synchronized void nScriptSetVarObj(long id, int slot, long val, boolean mUseInc) {
        this.validate();
        long curCon = this.mContext;
        if (mUseInc) {
            curCon = this.mIncCon;
        }
        this.rsnScriptSetVarObj(curCon, id, slot, val, mUseInc);
    }

    native long rsnScriptCCreate(long var1, String var3, String var4, byte[] var5, int var6);

    synchronized long nScriptCCreate(String resName, String cacheDir, byte[] script, int length) {
        this.validate();
        return this.rsnScriptCCreate(this.mContext, resName, cacheDir, script, length);
    }

    native long rsnScriptIntrinsicCreate(long var1, int var3, long var4, boolean var6);

    synchronized long nScriptIntrinsicCreate(int id, long eid, boolean mUseInc) {
        this.validate();
        if (mUseInc) {
            if (Build.VERSION.SDK_INT < 21) {
                Log.e((String)LOG_TAG, (String)"Incremental Intrinsics are not supported, please change targetSdkVersion to >= 21");
                throw new RSRuntimeException("Incremental Intrinsics are not supported before Lollipop (API 21)");
            }
            if (!this.mIncLoaded) {
                try {
                    System.loadLibrary("RSSupport");
                }
                catch (UnsatisfiedLinkError e) {
                    Log.e((String)LOG_TAG, (String)("Error loading RS Compat library for Incremental Intrinsic Support: " + e));
                    throw new RSRuntimeException("Error loading RS Compat library for Incremental Intrinsic Support: " + e);
                }
                if (!this.nIncLoadSO(23, this.mNativeLibDir + "/libRSSupport.so")) {
                    throw new RSRuntimeException("Error loading libRSSupport library for Incremental Intrinsic Support");
                }
                this.mIncLoaded = true;
            }
            if (this.mIncCon == 0L) {
                long device = this.nIncDeviceCreate();
                this.mIncCon = this.nIncContextCreate(device, 0, 0, 0);
            }
            return this.rsnScriptIntrinsicCreate(this.mIncCon, id, eid, mUseInc);
        }
        return this.rsnScriptIntrinsicCreate(this.mContext, id, eid, mUseInc);
    }

    native long rsnScriptKernelIDCreate(long var1, long var3, int var5, int var6, boolean var7);

    synchronized long nScriptKernelIDCreate(long sid, int slot, int sig, boolean mUseInc) {
        this.validate();
        long curCon = this.mContext;
        if (mUseInc) {
            curCon = this.mIncCon;
        }
        return this.rsnScriptKernelIDCreate(curCon, sid, slot, sig, mUseInc);
    }

    native long rsnScriptInvokeIDCreate(long var1, long var3, int var5);

    synchronized long nScriptInvokeIDCreate(long sid, int slot) {
        this.validate();
        return this.rsnScriptInvokeIDCreate(this.mContext, sid, slot);
    }

    native long rsnScriptFieldIDCreate(long var1, long var3, int var5, boolean var6);

    synchronized long nScriptFieldIDCreate(long sid, int slot, boolean mUseInc) {
        this.validate();
        long curCon = this.mContext;
        if (mUseInc) {
            curCon = this.mIncCon;
        }
        return this.rsnScriptFieldIDCreate(curCon, sid, slot, mUseInc);
    }

    native long rsnScriptGroupCreate(long var1, long[] var3, long[] var4, long[] var5, long[] var6, long[] var7);

    synchronized long nScriptGroupCreate(long[] kernels, long[] src, long[] dstk, long[] dstf, long[] types) {
        this.validate();
        return this.rsnScriptGroupCreate(this.mContext, kernels, src, dstk, dstf, types);
    }

    native void rsnScriptGroupSetInput(long var1, long var3, long var5, long var7);

    synchronized void nScriptGroupSetInput(long group, long kernel, long alloc) {
        this.validate();
        this.rsnScriptGroupSetInput(this.mContext, group, kernel, alloc);
    }

    native void rsnScriptGroupSetOutput(long var1, long var3, long var5, long var7);

    synchronized void nScriptGroupSetOutput(long group, long kernel, long alloc) {
        this.validate();
        this.rsnScriptGroupSetOutput(this.mContext, group, kernel, alloc);
    }

    native void rsnScriptGroupExecute(long var1, long var3);

    synchronized void nScriptGroupExecute(long group) {
        this.validate();
        this.rsnScriptGroupExecute(this.mContext, group);
    }

    native long rsnSamplerCreate(long var1, int var3, int var4, int var5, int var6, int var7, float var8);

    synchronized long nSamplerCreate(int magFilter, int minFilter, int wrapS, int wrapT, int wrapR, float aniso) {
        this.validate();
        return this.rsnSamplerCreate(this.mContext, magFilter, minFilter, wrapS, wrapT, wrapR, aniso);
    }

    native long rsnClosureCreate(long var1, long var3, long var5, long[] var7, long[] var8, int[] var9, long[] var10, long[] var11);

    synchronized long nClosureCreate(long kernelID, long returnValue, long[] fieldIDs, long[] values, int[] sizes, long[] depClosures, long[] depFieldIDs) {
        this.validate();
        long c = this.rsnClosureCreate(this.mContext, kernelID, returnValue, fieldIDs, values, sizes, depClosures, depFieldIDs);
        if (c == 0L) {
            throw new RSRuntimeException("Failed creating closure.");
        }
        return c;
    }

    native long rsnInvokeClosureCreate(long var1, long var3, byte[] var5, long[] var6, long[] var7, int[] var8);

    synchronized long nInvokeClosureCreate(long invokeID, byte[] params, long[] fieldIDs, long[] values, int[] sizes) {
        this.validate();
        long c = this.rsnInvokeClosureCreate(this.mContext, invokeID, params, fieldIDs, values, sizes);
        if (c == 0L) {
            throw new RSRuntimeException("Failed creating closure.");
        }
        return c;
    }

    native void rsnClosureSetArg(long var1, long var3, int var5, long var6, int var8);

    synchronized void nClosureSetArg(long closureID, int index, long value, int size) {
        this.validate();
        this.rsnClosureSetArg(this.mContext, closureID, index, value, size);
    }

    native void rsnClosureSetGlobal(long var1, long var3, long var5, long var7, int var9);

    synchronized void nClosureSetGlobal(long closureID, long fieldID, long value, int size) {
        this.validate();
        this.rsnClosureSetGlobal(this.mContext, closureID, fieldID, value, size);
    }

    native long rsnScriptGroup2Create(long var1, String var3, String var4, long[] var5);

    synchronized long nScriptGroup2Create(String name, String cachePath, long[] closures) {
        this.validate();
        return this.rsnScriptGroup2Create(this.mContext, name, cachePath, closures);
    }

    native void rsnScriptGroup2Execute(long var1, long var3);

    synchronized void nScriptGroup2Execute(long groupID) {
        this.validate();
        this.rsnScriptGroup2Execute(this.mContext, groupID);
    }

    native void rsnScriptIntrinsicBLAS_Single(long var1, long var3, long var5, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, float var16, long var17, long var19, float var21, long var22, int var24, int var25, int var26, int var27, boolean var28);

    synchronized void nScriptIntrinsicBLAS_Single(long id, int func, int TransA, int TransB, int Side2, int Uplo2, int Diag2, int M, int N, int K, float alpha, long A, long B, float beta, long C, int incX, int incY, int KL, int KU, boolean mUseInc) {
        this.validate();
        this.rsnScriptIntrinsicBLAS_Single(this.mContext, this.mIncCon, id, func, TransA, TransB, Side2, Uplo2, Diag2, M, N, K, alpha, A, B, beta, C, incX, incY, KL, KU, mUseInc);
    }

    native void rsnScriptIntrinsicBLAS_Double(long var1, long var3, long var5, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, double var16, long var18, long var20, double var22, long var24, int var26, int var27, int var28, int var29, boolean var30);

    synchronized void nScriptIntrinsicBLAS_Double(long id, int func, int TransA, int TransB, int Side2, int Uplo2, int Diag2, int M, int N, int K, double alpha, long A, long B, double beta, long C, int incX, int incY, int KL, int KU, boolean mUseInc) {
        this.validate();
        this.rsnScriptIntrinsicBLAS_Double(this.mContext, this.mIncCon, id, func, TransA, TransB, Side2, Uplo2, Diag2, M, N, K, alpha, A, B, beta, C, incX, incY, KL, KU, mUseInc);
    }

    native void rsnScriptIntrinsicBLAS_Complex(long var1, long var3, long var5, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, float var16, float var17, long var18, long var20, float var22, float var23, long var24, int var26, int var27, int var28, int var29, boolean var30);

    synchronized void nScriptIntrinsicBLAS_Complex(long id, int func, int TransA, int TransB, int Side2, int Uplo2, int Diag2, int M, int N, int K, float alphaX, float alphaY, long A, long B, float betaX, float betaY, long C, int incX, int incY, int KL, int KU, boolean mUseInc) {
        this.validate();
        this.rsnScriptIntrinsicBLAS_Complex(this.mContext, this.mIncCon, id, func, TransA, TransB, Side2, Uplo2, Diag2, M, N, K, alphaX, alphaY, A, B, betaX, betaY, C, incX, incY, KL, KU, mUseInc);
    }

    native void rsnScriptIntrinsicBLAS_Z(long var1, long var3, long var5, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, double var16, double var18, long var20, long var22, double var24, double var26, long var28, int var30, int var31, int var32, int var33, boolean var34);

    synchronized void nScriptIntrinsicBLAS_Z(long id, int func, int TransA, int TransB, int Side2, int Uplo2, int Diag2, int M, int N, int K, double alphaX, double alphaY, long A, long B, double betaX, double betaY, long C, int incX, int incY, int KL, int KU, boolean mUseInc) {
        this.validate();
        this.rsnScriptIntrinsicBLAS_Z(this.mContext, this.mIncCon, id, func, TransA, TransB, Side2, Uplo2, Diag2, M, N, K, alphaX, alphaY, A, B, betaX, betaY, C, incX, incY, KL, KU, mUseInc);
    }

    native void rsnScriptIntrinsicBLAS_BNNM(long var1, long var3, long var5, int var7, int var8, int var9, long var10, int var12, long var13, int var15, long var16, int var18, int var19, boolean var20);

    synchronized void nScriptIntrinsicBLAS_BNNM(long id, int M, int N, int K, long A, int a_offset, long B, int b_offset, long C, int c_offset, int c_mult_int, boolean mUseInc) {
        this.validate();
        this.rsnScriptIntrinsicBLAS_BNNM(this.mContext, this.mIncCon, id, M, N, K, A, a_offset, B, b_offset, C, c_offset, c_mult_int, mUseInc);
    }

    native boolean nIncLoadSO(int var1, String var2);

    native long nIncDeviceCreate();

    native void nIncDeviceDestroy(long var1);

    native long rsnIncContextCreate(long var1, int var3, int var4, int var5);

    synchronized long nIncContextCreate(long dev, int ver, int sdkVer, int contextType) {
        return this.rsnIncContextCreate(dev, ver, sdkVer, contextType);
    }

    native void rsnIncContextDestroy(long var1);

    synchronized void nIncContextDestroy() {
        this.validate();
        ReentrantReadWriteLock.WriteLock wlock = this.mRWLock.writeLock();
        wlock.lock();
        long curCon = this.mIncCon;
        this.mIncCon = 0L;
        wlock.unlock();
        this.rsnIncContextDestroy(curCon);
    }

    native void rsnIncContextFinish(long var1);

    synchronized void nIncContextFinish() {
        this.validate();
        this.rsnIncContextFinish(this.mIncCon);
    }

    native void rsnIncObjDestroy(long var1, long var3);

    void nIncObjDestroy(long id) {
        if (this.mIncCon != 0L) {
            this.rsnIncObjDestroy(this.mIncCon, id);
        }
    }

    native long rsnIncElementCreate(long var1, long var3, int var5, boolean var6, int var7);

    synchronized long nIncElementCreate(long type, int kind, boolean norm, int vecSize) {
        this.validate();
        return this.rsnIncElementCreate(this.mIncCon, type, kind, norm, vecSize);
    }

    native long rsnIncTypeCreate(long var1, long var3, int var5, int var6, int var7, boolean var8, boolean var9, int var10);

    synchronized long nIncTypeCreate(long eid, int x, int y, int z, boolean mips, boolean faces, int yuv) {
        this.validate();
        return this.rsnIncTypeCreate(this.mIncCon, eid, x, y, z, mips, faces, yuv);
    }

    native long rsnIncAllocationCreateTyped(long var1, long var3, long var5, long var7, int var9);

    synchronized long nIncAllocationCreateTyped(long alloc, long type, int xBytesSize) {
        this.validate();
        return this.rsnIncAllocationCreateTyped(this.mContext, this.mIncCon, alloc, type, xBytesSize);
    }

    public void setMessageHandler(RSMessageHandler msg) {
        this.mMessageCallback = msg;
    }

    public RSMessageHandler getMessageHandler() {
        return this.mMessageCallback;
    }

    public void sendMessage(int id, int[] data) {
        this.nContextSendMessage(id, data);
    }

    public void setErrorHandler(RSErrorHandler msg) {
        this.mErrorCallback = msg;
    }

    public RSErrorHandler getErrorHandler() {
        return this.mErrorCallback;
    }

    void validateObject(BaseObj o) {
        if (o != null && o.mRS != this) {
            throw new RSIllegalArgumentException("Attempting to use an object across contexts.");
        }
    }

    void validate() {
        if (this.mContext == 0L) {
            throw new RSInvalidStateException("Calling RS with no Context active.");
        }
    }

    boolean usingIO() {
        return useIOlib;
    }

    public void setPriority(Priority p) {
        this.validate();
        this.nContextSetPriority(p.mID);
    }

    RenderScript(Context ctx) {
        if (ctx != null) {
            this.mApplicationContext = ctx.getApplicationContext();
            this.mNativeLibDir = this.mApplicationContext.getApplicationInfo().nativeLibraryDir;
        }
        this.mIncCon = 0L;
        this.mIncLoaded = false;
        this.mRWLock = new ReentrantReadWriteLock();
    }

    public final Context getApplicationContext() {
        return this.mApplicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RenderScript internalCreate(Context ctx, int sdkVersion, ContextType ct, int flags) {
        RenderScript rs = new RenderScript(ctx);
        if (sSdkVersion == -1) {
            sSdkVersion = sdkVersion;
        } else if (sSdkVersion != sdkVersion) {
            throw new RSRuntimeException("Can't have two contexts with different SDK versions in support lib");
        }
        useNative = RenderScript.setupNative(sSdkVersion, ctx);
        Object object = lock;
        synchronized (object) {
            if (!sInitialized) {
                try {
                    Class<?> vm_runtime = Class.forName("dalvik.system.VMRuntime");
                    Method get_runtime = vm_runtime.getDeclaredMethod("getRuntime", new Class[0]);
                    sRuntime = get_runtime.invoke(null, new Object[0]);
                    registerNativeAllocation = vm_runtime.getDeclaredMethod("registerNativeAllocation", Integer.TYPE);
                    registerNativeFree = vm_runtime.getDeclaredMethod("registerNativeFree", Integer.TYPE);
                    sUseGCHooks = true;
                }
                catch (Exception e) {
                    Log.e((String)LOG_TAG, (String)"No GC methods");
                    sUseGCHooks = false;
                }
                try {
                    if (Build.VERSION.SDK_INT < 23 && rs.mNativeLibDir != null) {
                        System.load(rs.mNativeLibDir + "/librsjni_androidx.so");
                    } else {
                        System.loadLibrary("rsjni_androidx");
                    }
                    sInitialized = true;
                    sPointerSize = RenderScript.rsnSystemGetPointerSize();
                }
                catch (UnsatisfiedLinkError e) {
                    Log.e((String)LOG_TAG, (String)("Error loading RS jni library: " + e));
                    throw new RSRuntimeException("Error loading RS jni library: " + e + " Support lib API: " + 2301);
                }
            }
        }
        if (useNative) {
            Log.v((String)LOG_TAG, (String)"RS native mode");
        } else {
            Log.v((String)LOG_TAG, (String)"RS compat mode");
        }
        if (Build.VERSION.SDK_INT >= 14) {
            useIOlib = true;
        }
        int dispatchAPI = sdkVersion;
        if (sdkVersion < Build.VERSION.SDK_INT) {
            dispatchAPI = Build.VERSION.SDK_INT;
        }
        String rssupportPath = null;
        if (Build.VERSION.SDK_INT < 23 && rs.mNativeLibDir != null) {
            rssupportPath = rs.mNativeLibDir + "/libRSSupport.so";
        }
        if (!rs.nLoadSO(useNative, dispatchAPI, rssupportPath)) {
            if (useNative) {
                Log.v((String)LOG_TAG, (String)"Unable to load libRS.so, falling back to compat mode");
                useNative = false;
            }
            try {
                if (Build.VERSION.SDK_INT < 23 && rs.mNativeLibDir != null) {
                    System.load(rssupportPath);
                } else {
                    System.loadLibrary("RSSupport");
                }
            }
            catch (UnsatisfiedLinkError e) {
                Log.e((String)LOG_TAG, (String)("Error loading RS Compat library: " + e + " Support lib version: " + 2301));
                throw new RSRuntimeException("Error loading RS Compat library: " + e + " Support lib version: " + 2301);
            }
            if (!rs.nLoadSO(false, dispatchAPI, rssupportPath)) {
                Log.e((String)LOG_TAG, (String)"Error loading RS Compat library: nLoadSO() failed; Support lib version: 2301");
                throw new RSRuntimeException("Error loading libRSSupport library, Support lib version: 2301");
            }
        }
        if (useIOlib) {
            try {
                System.loadLibrary("RSSupportIO");
            }
            catch (UnsatisfiedLinkError e) {
                useIOlib = false;
            }
            if (!useIOlib || !rs.nLoadIOSO()) {
                Log.v((String)LOG_TAG, (String)"Unable to load libRSSupportIO.so, USAGE_IO not supported");
                useIOlib = false;
            }
        }
        if (dispatchAPI >= 23) {
            rs.mEnableMultiInput = true;
            try {
                System.loadLibrary("blasV8");
            }
            catch (UnsatisfiedLinkError e) {
                Log.v((String)LOG_TAG, (String)("Unable to load BLAS lib, ONLY BNNM will be supported: " + e));
            }
        }
        long device = rs.nDeviceCreate();
        rs.mContext = rs.nContextCreate(device, 0, sdkVersion, ct.mID, rs.mNativeLibDir);
        rs.mContextType = ct;
        rs.mContextFlags = flags;
        rs.mContextSdkVersion = sdkVersion;
        rs.mDispatchAPILevel = dispatchAPI;
        if (rs.mContext == 0L) {
            throw new RSDriverException("Failed to create RS context.");
        }
        rs.mMessageThread = new MessageThread(rs);
        rs.mMessageThread.start();
        return rs;
    }

    public static RenderScript create(Context ctx) {
        return RenderScript.create(ctx, ContextType.NORMAL);
    }

    public static RenderScript create(Context ctx, ContextType ct) {
        return RenderScript.create(ctx, ct, 0);
    }

    public static RenderScript create(Context ctx, ContextType ct, int flags) {
        int v = ctx.getApplicationInfo().targetSdkVersion;
        return RenderScript.create(ctx, v, ct, flags);
    }

    public static RenderScript create(Context ctx, int sdkVersion) {
        return RenderScript.create(ctx, sdkVersion, ContextType.NORMAL, 0);
    }

    public static RenderScript create(Context ctx, int sdkVersion, ContextType ct) {
        return RenderScript.create(ctx, sdkVersion, ct, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RenderScript create(Context ctx, int sdkVersion, ContextType ct, int flags) {
        ArrayList<RenderScript> arrayList = mProcessContextList;
        synchronized (arrayList) {
            for (RenderScript prs : mProcessContextList) {
                if (prs.mContextType != ct || prs.mContextFlags != flags || prs.mContextSdkVersion != sdkVersion) continue;
                return prs;
            }
            RenderScript prs = RenderScript.internalCreate(ctx, sdkVersion, ct, flags);
            prs.mIsProcessContext = true;
            mProcessContextList.add(prs);
            return prs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAllContexts() {
        ArrayList<RenderScript> oldList;
        ArrayList<RenderScript> arrayList = mProcessContextList;
        synchronized (arrayList) {
            oldList = mProcessContextList;
            mProcessContextList = new ArrayList();
        }
        for (RenderScript prs : oldList) {
            prs.mIsProcessContext = false;
            prs.destroy();
        }
        oldList.clear();
    }

    public static RenderScript createMultiContext(Context ctx, ContextType ct, int flags, int API_number) {
        return RenderScript.internalCreate(ctx, API_number, ct, flags);
    }

    public void contextDump() {
        this.validate();
        this.nContextDump(0);
    }

    public void finish() {
        this.nContextFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void helpDestroy() {
        boolean shouldDestroy = false;
        RenderScript renderScript = this;
        synchronized (renderScript) {
            if (!this.mDestroyed) {
                shouldDestroy = true;
                this.mDestroyed = true;
            }
        }
        if (shouldDestroy) {
            this.nContextFinish();
            if (this.mIncCon != 0L) {
                this.nIncContextFinish();
                this.nIncContextDestroy();
                this.mIncCon = 0L;
            }
            this.nContextDeinitToClient(this.mContext);
            this.mMessageThread.mRun = false;
            this.mMessageThread.interrupt();
            boolean hasJoined = false;
            boolean interrupted = false;
            while (!hasJoined) {
                try {
                    this.mMessageThread.join();
                    hasJoined = true;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Log.v((String)LOG_TAG, (String)"Interrupted during wait for MessageThread to join");
                Thread.currentThread().interrupt();
            }
            this.nContextDestroy();
        }
    }

    protected void finalize() throws Throwable {
        this.helpDestroy();
        super.finalize();
    }

    public void destroy() {
        if (this.mIsProcessContext) {
            return;
        }
        this.validate();
        this.helpDestroy();
    }

    boolean isAlive() {
        return this.mContext != 0L;
    }

    long safeID(BaseObj o) {
        if (o != null) {
            return o.getID(this);
        }
        return 0L;
    }

    static {
        lock = new Object();
        sNative = -1;
        sSdkVersion = -1;
        useIOlib = false;
    }

    static class MessageThread
    extends Thread {
        RenderScript mRS;
        boolean mRun = true;
        int[] mAuxData = new int[2];
        static final int RS_MESSAGE_TO_CLIENT_NONE = 0;
        static final int RS_MESSAGE_TO_CLIENT_EXCEPTION = 1;
        static final int RS_MESSAGE_TO_CLIENT_RESIZE = 2;
        static final int RS_MESSAGE_TO_CLIENT_ERROR = 3;
        static final int RS_MESSAGE_TO_CLIENT_USER = 4;
        static final int RS_ERROR_FATAL_DEBUG = 2048;
        static final int RS_ERROR_FATAL_UNKNOWN = 4096;

        MessageThread(RenderScript rs) {
            super("RSMessageThread");
            this.mRS = rs;
        }

        @Override
        public void run() {
            int[] rbuf = new int[16];
            this.mRS.nContextInitToClient(this.mRS.mContext);
            while (this.mRun) {
                rbuf[0] = 0;
                int msg = this.mRS.nContextPeekMessage(this.mRS.mContext, this.mAuxData);
                int size = this.mAuxData[1];
                int subID = this.mAuxData[0];
                if (msg == 4) {
                    if (size >> 2 >= rbuf.length) {
                        rbuf = new int[size + 3 >> 2];
                    }
                    if (this.mRS.nContextGetUserMessage(this.mRS.mContext, rbuf) != 4) {
                        throw new RSDriverException("Error processing message from RenderScript.");
                    }
                    if (this.mRS.mMessageCallback != null) {
                        this.mRS.mMessageCallback.mData = rbuf;
                        this.mRS.mMessageCallback.mID = subID;
                        this.mRS.mMessageCallback.mLength = size;
                        this.mRS.mMessageCallback.run();
                        continue;
                    }
                    throw new RSInvalidStateException("Received a message from the script with no message handler installed.");
                }
                if (msg == 3) {
                    String e = this.mRS.nContextGetErrorMessage(this.mRS.mContext);
                    if (subID >= 4096 || subID >= 2048 && (this.mRS.mContextType != ContextType.DEBUG || this.mRS.mErrorCallback == null)) {
                        Log.e((String)RenderScript.LOG_TAG, (String)("fatal RS error, " + e));
                        throw new RSRuntimeException("Fatal error " + subID + ", details: " + e);
                    }
                    if (this.mRS.mErrorCallback != null) {
                        this.mRS.mErrorCallback.mErrorMessage = e;
                        this.mRS.mErrorCallback.mErrorNum = subID;
                        this.mRS.mErrorCallback.run();
                        continue;
                    }
                    Log.e((String)RenderScript.LOG_TAG, (String)("non fatal RS error, " + e));
                    continue;
                }
                try {
                    MessageThread.sleep(1L, 0);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static enum Priority {
        LOW(15),
        NORMAL(-4);

        int mID;

        private Priority(int id) {
            this.mID = id;
        }
    }

    public static class RSErrorHandler
    implements Runnable {
        protected String mErrorMessage;
        protected int mErrorNum;

        @Override
        public void run() {
        }
    }

    public static class RSMessageHandler
    implements Runnable {
        protected int[] mData;
        protected int mID;
        protected int mLength;

        @Override
        public void run() {
        }
    }

    public static enum ContextType {
        NORMAL(0),
        DEBUG(1),
        PROFILE(2);

        int mID;

        private ContextType(int id) {
            this.mID = id;
        }
    }
}

